/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import java.io.Serializable;

public class MessageText
extends LocalizableText
implements Serializable {
    private MsgType msgType = null;
    private String msgId = null;

    public MessageText(String bundleName, String key) {
        this(bundleName, key, null);
    }

    public MessageText(String bundleName, String key, Object[] subst) {
        super(bundleName, key, subst);
    }

    public MessageText() {
    }

    public MessageText(String bundleName, String key, Object[] subst, MsgType msgType, String msgId) {
        super(bundleName, key, subst);
        this.msgType = msgType;
        this.msgId = msgId;
    }

    public MsgType getMsgType() {
        if (this.msgType == null) {
            return MessageText.getMsgType(this.getMsgId());
        }
        return this.msgType;
    }

    public static MsgType getMsgType(String inString) {
        if (inString.toUpperCase().endsWith("I")) {
            return MsgType.INFORMATION_MESSAGE;
        }
        if (inString.toUpperCase().endsWith("W")) {
            return MsgType.WARNING_MESSAGE;
        }
        if (inString.toUpperCase().endsWith("Q")) {
            return MsgType.QUESTION_MESSAGE;
        }
        if (inString.toUpperCase().endsWith("E")) {
            return MsgType.ERROR_MESSAGE;
        }
        return null;
    }

    public String toString() {
        return this.getMsgText();
    }

    public String getMsgText() {
        if (this.msgId == null) {
            String msgText = super.toString();
            if (10 < msgText.length()) {
                return msgText.substring(10);
            }
            return "";
        }
        return super.toString();
    }

    public String getMsgId() {
        if (this.msgId == null) {
            String msgText = super.toString();
            int endIndex = msgText.length();
            if (endIndex > 9) {
                endIndex = 9;
            }
            return msgText.substring(0, endIndex);
        }
        return this.msgId;
    }

    public String getMsgIdMinusType() {
        if (this.msgId == null) {
            return super.toString().substring(0, 8);
        }
        return this.msgId;
    }
}

